<?php
include("./connection.php");

function sendResponse($code, $msg = '', $payload = '')
{
    echo json_encode([
        'code' => $code,
        'msg' => $msg,
        'payload' => $payload
    ]);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $email = $_POST['email'] ?? '';
    $phone = $_POST['phone'] ?? '';
    $date = $_POST['date'] ?? '';
    $package = $_POST['package'] ?? '';

    if (!$name || !$email || !$phone || !$date || !$package) {
        sendResponse(400, 'Missing required fields');
        exit;
    }

    $stmt = $conn->prepare("INSERT INTO bookings (name, email, phone, date, package, createdAt) VALUES (?, ?, ?, ?, ?, NOW())");
    $stmt->bind_param("sssss", $name, $email, $phone, $date, $package);

    if ($stmt->execute()) {
        sendResponse(200, 'Booking added successfully');
    } else {
        sendResponse(500, 'Database error: ' . $stmt->error);
    }

    $stmt->close();
} else {
    http_response_code(405);
    sendResponse(405, "Method Not Allowed");
}
