<?php
include("./connection.php");

function sendResponse($code, $msg = '', $payload = '')
{
    echo json_encode([
        'code' => $code,
        'msg' => $msg,
        'payload' => $payload
    ]);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $email = $_POST['email'] ?? '';
    $message = $_POST['message'] ?? '';

    if (!$name || !$email || !$message) {
        sendResponse(400, 'Missing required fields');
        exit;
    }

    $stmt = $conn->prepare("INSERT INTO enquiries (name, email, message, createdAt) VALUES (?, ?, ?, NOW())");
    $stmt->bind_param("sss", $name, $email, $message);

    if ($stmt->execute()) {
        sendResponse(200, 'Enquiry submitted successfully');
    } else {
        sendResponse(500, 'Database error: ' . $stmt->error);
    }

    $stmt->close();
} else {
    http_response_code(405);
    sendResponse(405, "Method Not Allowed");
}
