<?php
function generate_jwt($headers, $payload, $secret = 'jamaicac_main_)ol08R5X7j+RHx')
{
    $headers_encoded = base64url_encode(json_encode($headers));

    $payload_encoded = base64url_encode(json_encode($payload));

    $signature = hash_hmac('SHA256', "$headers_encoded.$payload_encoded", $secret, true);
    $signature_encoded = base64url_encode($signature);

    $jwt = "$headers_encoded.$payload_encoded.$signature_encoded";

    return $jwt;
}

function is_jwt_valid($jwt, $secret = 'jamaicac_main_)ol08R5X7j+RHx')
{

    $res = [
        'status' => '',
        'payload' => '',
    ];

    $tokenParts = explode('.', $jwt);
    $header = base64_decode($tokenParts[0]);
    $payload = base64_decode($tokenParts[1]);
    $signature_provided = $tokenParts[2];

    $base64_url_header = base64url_encode($header);
    $base64_url_payload = base64url_encode($payload);
    $signature = hash_hmac('SHA256', $base64_url_header . "." . $base64_url_payload, $secret, true);
    $base64_url_signature = base64url_encode($signature);

    $is_signature_valid = ($base64_url_signature === $signature_provided);

    if (!$is_signature_valid) {
        $res['status'] = 'Failed';
    } else {
        $res['status'] = 'Success';
        $res['payload'] = json_decode($payload, 1);
    }

    $allvalue = json_encode($res);

    return $allvalue;
}

function base64url_encode($str)
{
    return rtrim(strtr(base64_encode($str), '+/', '-_'), '=');
}
