<?php
require 'config.php';
require 'jwt.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        $headers = ['alg' => 'HS256', 'typ' => 'JWT'];
        $payload = [
            'user_id' => $user['id'],
            'username' => $user['username'],
            'exp' => time() + 3600 // token expires in 1 hour
        ];

        $jwt = generate_jwt($headers, $payload);
        echo json_encode(['status' => 'success', 'token' => $jwt]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Invalid credentials']);
    }
}
