<?php
// CORS headers — add these at the very top
header("Access-Control-Allow-Origin: *"); // You can restrict to a specific domain like "https://jamaicacamp.com"
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

include("./connection.php");

function sendResponse($code, $msg = '', $payload = '')
{
    echo json_encode([
        'code' => $code,
        'msg' => $msg,
        'payload' => $payload
    ]);
    exit;
}

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Parse JSON input
    $data = json_decode(file_get_contents("php://input"), true);

    // Extract fields
    $name = trim($data['name'] ?? '');
    $email = trim($data['email'] ?? '');
    $phone = trim($data['phone'] ?? '');
    $message = trim($data['message'] ?? '');

    // Validate input
    if (!$name || !$email || !$phone || !$message) {
        sendResponse(400, 'Missing required fields');
    }

    // Insert into database
    $stmt = $conn->prepare("INSERT INTO enquiries (name, email, phone_number, message, createdAt) VALUES (?, ?, ?, ?, NOW())");
    $stmt->bind_param("ssss", $name, $email, $phone, $message);

    if ($stmt->execute()) {
        sendResponse(200, 'Enquiry submitted successfully');
    } else {
        sendResponse(500, 'Database error: ' . $stmt->error);
    }

    $stmt->close();
} else {
    http_response_code(405);
    sendResponse(405, "Method Not Allowed");
}
