<?php
include("connection.php");
include("jwt.php");

// Allow CORS
header("Access-Control-Allow-Origin: *"); // You can replace * with specific origin for security
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

header('Content-Type: application/json');

function sendResponse($code, $msg = '', $payload = '')
{
    echo json_encode([
        'code' => $code,
        'msg' => $msg,
        'payload' => $payload
    ]);
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') {


     // --- Authentication ---
    $headers = getallheaders();
    $auth_header = $headers['Authorization'] ?? '';

    if (!$auth_header || !str_starts_with($auth_header, 'Bearer ')) {
        sendResponse(401, 'Authorization header missing');
        exit;
    }

    $token = str_replace('Bearer ', '', $auth_header);
    $validation = json_decode(is_jwt_valid($token), true);

    if (!isset($validation['status']) || $validation['status'] !== 'Success') {
        sendResponse(403, 'Invalid or expired token');
        exit;
    }




    $query = "SELECT * FROM enquiries WHERE mark='0'";

    // Check if 'today' param is set and true
    if (isset($_GET['today']) && $_GET['today'] === 'true') {
        $today = date('Y-m-d');
        $query .= " AND DATE(createdAt) = '$today'";
    }

    $result = mysqli_query($conn, $query);

    if ($result) {
        $formattedEnquiries = [];

        while ($row = mysqli_fetch_assoc($result)) {
            $formattedEnquiries[] = [
                'id' => $row['id'],
                'name' => $row['name'],
                'email' => $row['email'],
                'details' => [
                    ['label' => 'Phone No', 'value' => $row['phone_number']],
                    ['label' => 'Message', 'value' => $row['message']]
                ],
            ];
        }

        sendResponse(200, 'success', $formattedEnquiries);
    } else {
        sendResponse(500, 'Database error: ' . mysqli_error($conn));
    }
} else {
    http_response_code(405);
    sendResponse(405, "Method Not Allowed");
}
