<?php
include("connection.php");
include("jwt.php");

// Allow CORS
header("Access-Control-Allow-Origin: *"); // Replace * with your domain in production
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

header('Content-Type: application/json');

function sendResponse($code, $msg = '', $payload = '')
{
    echo json_encode([
        'code' => $code,
        'msg' => $msg,
        'payload' => $payload
    ]);
}

if ($_SERVER['REQUEST_METHOD'] === 'GET') {

    // --- JWT Authentication ---
    $headers = getallheaders();
    $auth_header = $headers['Authorization'] ?? '';

    if (!$auth_header || !str_starts_with($auth_header, 'Bearer ')) {
        sendResponse(401, 'Authorization header missing');
        exit;
    }

    $token = str_replace('Bearer ', '', $auth_header);
    $validation = json_decode(is_jwt_valid($token), true);

    if (!isset($validation['status']) || $validation['status'] !== 'Success') {
        sendResponse(403, 'Invalid or expired token');
        exit;
    }


    $status = $_GET['status'] ?? '1';

    // --- Fetch Active Bookings ---
    $bookings = [];
    $sqlBookings = "SELECT * FROM bookings WHERE mark = '$status' ORDER BY createdAt DESC";
    $resultBookings = $conn->query($sqlBookings);

    if ($resultBookings && $resultBookings->num_rows > 0) {
        while ($row = $resultBookings->fetch_assoc()) {
            $bookings[] = [
                'id' => $row['id'],
                'name' => $row['name'],
                'email' => $row['email'],
                'phone' => $row['phone_number'],
                'address' => $row['address'],
                'site' => $row['site'],
                'groupSize' => $row['group_size'],
                'checkin' => $row['checkin'],
                'checkout' => $row['checkout'],
                'createdAt' => $row['createdAt'],
                'updatedAt' => $row['updatedAt'],
            ];
        }
    }

    // --- Fetch Active Enquiries ---
    $enquiries = [];
    $sqlEnquiries = "SELECT * FROM enquiries WHERE mark = '$status' ORDER BY createdAt DESC";
    $resultEnquiries = $conn->query($sqlEnquiries);

    if ($resultEnquiries && $resultEnquiries->num_rows > 0) {
        while ($row = $resultEnquiries->fetch_assoc()) {
            $enquiries[] = [
                'id' => $row['id'],
                'name' => $row['name'],
                'email' => $row['email'],
                'phone' => $row['phone_number'],
                'message' => $row['message'],
                'createdAt' => $row['createdAt'],
                'updatedAt' => $row['updatedAt'],
            ];
        }
    }

    // --- Respond with data ---
    sendResponse(200, 'Active records fetched successfully', [
        'bookings' => $bookings,
        'enquiries' => $enquiries
    ]);

} else {
    http_response_code(405);
    sendResponse(405, "Method Not Allowed");
}
